#ifndef _PHY_ISR_H_
#define _PHY_ISR_H_


/************************************************************************************
*************************************************************************************
* Private definitions
*************************************************************************************
************************************************************************************/

//
#define PhyTxFlags_PacketSent (1 << 0)
#define PhyTxFlags_TxTimeout  (1 << 1)

//
#define PhyRxFlags_SfdReceived      (1 << 0)
#define PhyRxFlags_PhrReceived      (1 << 1)
#define PhyRxFlags_LqiDone          (1 << 2)
#define PhyRxFlags_RxTimeout        (1 << 3)
#define PhyRxFlags_RxDone           (1 << 4)
#define PhyRxFlags_InvalidLength    (1 << 5)
#define PhyRxFlags_CrcError         (1 << 6)
#define PhyRxFlags_EnableAckFilter  (1 << 7)

//
#define PhyCcaFlags_RxReadyReceived (1 << 0)
#define PhyCcaFlags_CcaTimeout      (1 << 1)
#define PhyCcaFlags_CcaDone         (1 << 2)




/************************************************************************************
*************************************************************************************
* Private prototypes
*************************************************************************************
************************************************************************************/

void MKW01Drv_FillFifo(void);
void MKW01Drv_UnFillFifo(void);

void PhyRxHandleSyncAddresEvent(void);
void PhyRxHandlePHREvent(void);
void PhyRxHandleFifoLevelEvent(void);
void PhyRxHandlePayloadReadyEvent(void);
void PhyRxHandleDummyEvent(void);



void PhyTxHandleDummyEvent(void);
void PhyTxPacketSentEvent(void);
void PhyTxHandleFifoLevelEvent(void);

void PhyTimeHandleEventTimeout(void);
void PhyTimeHandleEventTrigger(void);


void MKW01HandlerInterrupt(void);
void Phy_ISR(void);
void CCAPinHandler_Interrupt(void);

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/

extern void (* gpfPendingRxEvent)(void);
extern void (* gpfPendingTxEvent)(void);

#endif /* _PHY_ISR_H_ */
